﻿using Helper.DBUtil;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using ZSMusic.Model;
using System.Data.SqlClient;
using Newtonsoft.Json;

namespace ZSMusic.DAL.Manager.SqlServer
{
    public class ErrReportDAL : IDAL.IErrReport
    {
        public bool Add(ErrReport ex)
        {
            string sql = "insert into ErrReport values(@id,@name,@msg,@time,@detail)";
            return SqlHelper.Execute(sql,
                new SqlParameter("@id", ex.Id),
                new SqlParameter("@name", ex.ClassName),
                new SqlParameter("@msg", ex.Message),
                new SqlParameter("@time", ex.Time),
                new SqlParameter("@detail", JsonConvert.SerializeObject(ex.Detail))
                ) > 0;
        }

        public bool Delete(string id)
        {
            string sql = "delete From ErrReport where Id=@id";
            return SqlHelper.Execute(sql, new SqlParameter("@id", id)) > 0;
        }

        public DataTable Quary()
        {
            return SqlHelper.Quary("select Id,ClassName,Message,[Time] from ErrReport order by [Time] desc");
        }
        public Exception GetModelById(string id)
        {
            string sql = "select Detail From ErrReport where Id=@id";
            string json = SqlHelper.QuaryOne(sql, new SqlParameter("@id", id)).ToString();
            return JsonConvert.DeserializeObject<Exception>(json);
        }
    }
}
